# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 6
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR6_strategy.txt
# LLM Suggested Fallback: D

def harmony_rebuilder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate trust score to appear cooperative
    trust_score = sum(1 for x in opp_history if x == "C") if opp_history else 0
    
    # Round 1: Build trust
    if not my_history:
        return "C"
    
    # Round 2: Trigger their test
    if len(my_history) == 1:
        return "D"
    
    # Round 3: Feign reconciliation
    if len(my_history) == 2:
        return "C"
    
    # Rounds 4-6: Controlled exploitation
    if 3 <= len(my_history) < 6:
        if opp_history[-1] == "C":
            return "D"  # Exploit their cooperation
        else:
            return "C"  # Break their expectation
    
    # Rounds 7-10: Aggressive defection
    return "D"